/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.CreateException;
import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.exception.UpdateException;
import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.Models;
import com.quantumdata.sct.dao.jaxb.ModelsType;
import com.quantumdata.sct.dao.jaxb.Standard;
import com.quantumdata.sct.dao.jaxb.impl.ModelsTypeImpl;
import com.quantumdata.sct.dao.vo.ModelVO;
import com.quantumdata.sct.util.keygen.KeyGenerator;
import com.quantumdata.sct.util.keygen.RandTSKeyGenerator;
import javax.xml.bind.Validator;

public class ModelDAO
extends AbstractXMLStorageDAO {
    private KeyGenerator keygen = RandTSKeyGenerator.instance();

    public void readCallback() throws DAOException {
        try {
            Models models = (Models)this.daoObject;
            int n = models.getModelsCollection().size();
            this.daoCollection.clear();
            for (int i = 0; i < n; ++i) {
                ModelsType.Model model = (ModelsType.Model)((Models)this.daoObject).getModelsCollection().get(i);
                this.daoCollection.put(model.getId(), new Integer(i));
            }
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to load", null, exception);
        }
    }

    public Object getUniqueKey() {
        return this.keygen.generateUniqueKey();
    }

    public IPersistable getValueObjectForKey(Object object) throws CreateException {
        try {
            return this.findByPrimaryKey((String)object);
        }
        catch (Exception exception) {
            throw new CreateException("Unable to create with key =" + object, null, exception);
        }
    }

    public IPersistable[] findByAll() throws Exception {
        int n = ((ModelsTypeImpl)this.daoObject).getModelsCollection().size();
        IPersistable[] iPersistableArray = new IPersistable[n];
        for (int i = 0; i < n; ++i) {
            ModelsTypeImpl.ModelImpl modelImpl = (ModelsTypeImpl.ModelImpl)((Models)this.daoObject).getModelsCollection().get(i);
            iPersistableArray[i] = this.createPersistable(modelImpl);
        }
        return iPersistableArray;
    }

    public Object getUniqueKey(Object object) {
        Object object2 = null;
        if (object instanceof Standard) {
            Standard standard = (Standard)object;
            object2 = standard.getId();
        } else {
            object2 = this.getUniqueKey();
        }
        return object2;
    }

    public final IPersistable createPersistable(Object object) {
        ModelVO modelVO = new ModelVO();
        if (object instanceof ModelsTypeImpl.ModelImpl) {
            this.copyFrom((ModelsTypeImpl.ModelImpl)object, modelVO);
        }
        return modelVO;
    }

    protected void copyFrom(ModelsTypeImpl.ModelImpl modelImpl, ModelVO modelVO) {
        modelVO.setId(modelImpl.getId());
        modelVO.setDescription(modelImpl.getDescription());
        modelVO.setManufacturer(modelImpl.getManufacturer());
        modelVO.setUpdateable(modelImpl.isUpdateable());
        modelVO.setDeletable(modelImpl.isDeletable());
        modelVO.setNumber(modelImpl.getNumber());
        modelVO.setName(modelImpl.getName());
        modelVO.setLastUpdate(modelImpl.getLastUpdateTime());
        modelVO.setPartNumber(modelImpl.getPartNumber());
        modelVO.setUpc(modelImpl.getUpc());
    }

    protected void copyTo(ModelsTypeImpl.ModelImpl modelImpl, ModelVO modelVO) {
        modelImpl.setId((String)modelVO.getId());
        modelImpl.setDescription(modelVO.getDescription());
        modelImpl.setManufacturer(modelVO.getManufacturer());
        modelImpl.setUpdateable(modelVO.isUpdateable());
        modelImpl.setDeletable(modelVO.isDeletable());
        modelImpl.setNumber(modelVO.getNumber());
        modelImpl.setName(modelVO.getName());
        modelImpl.setLastUpdateTime(modelVO.getLastUpdate());
        modelImpl.setUpc(modelVO.getUpc());
        modelImpl.setPartNumber(modelVO.getPartNumber());
    }

    public final void update(IPersistable iPersistable) throws UpdateException {
        if (iPersistable instanceof ModelVO) {
            ModelVO modelVO = (ModelVO)iPersistable;
            if (this.daoCollection.containsKey(modelVO.getId()) && modelVO.isDirty()) {
                Object v = this.daoCollection.get(modelVO.getId());
                System.out.println(v.getClass().getName());
                Integer n = (Integer)this.daoCollection.get(modelVO.getId());
                ModelsTypeImpl.ModelImpl modelImpl = (ModelsTypeImpl.ModelImpl)((Models)this.daoObject).getModelsCollection().get(n);
                this.copyTo(modelImpl, modelVO);
                try {
                    this.flush();
                }
                catch (DAOException dAOException) {
                    dAOException.printStackTrace();
                }
            }
        } else {
            throw new UpdateException("Invalid Object", null);
        }
    }

    protected void updateObject(IPersistable iPersistable) {
        if (this.daoCollection.containsKey(iPersistable.getId())) {
            Integer n = (Integer)this.daoCollection.get(iPersistable.getId());
            ModelsTypeImpl.ModelImpl modelImpl = (ModelsTypeImpl.ModelImpl)((Models)this.daoObject).getModelsCollection().get(n);
            this.copyTo(modelImpl, (ModelVO)iPersistable);
        }
    }

    public final IPersistable findByPrimaryKey(String string) {
        ModelVO modelVO = null;
        if (this.daoCollection.containsKey(string)) {
            Integer n = (Integer)this.daoCollection.get(string);
            ModelsTypeImpl.ModelImpl modelImpl = (ModelsTypeImpl.ModelImpl)((Models)this.daoObject).getModelsCollection().get(n);
            ModelVO modelVO2 = new ModelVO();
            this.copyFrom(modelImpl, modelVO2);
            modelVO = modelVO2;
        }
        return modelVO;
    }

    protected final void removeByPrimaryKey(Object object) throws DAOException {
        try {
            if (object instanceof String) {
                int n = (Integer)this.daoCollection.get(object);
                ((Models)this.daoObject).getModelsCollection().remove(n);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DAOException(throwable.getMessage());
        }
    }

    public void validate() throws Exception {
        Validator validator = this._jc.createValidator();
        validator.validate(this.daoObject);
    }

    public void add(IPersistable iPersistable, int n) throws CreateException {
        try {
            int n2 = ((Models)this.daoObject).getModelsCollection().size();
            if (!(iPersistable instanceof ModelVO) || n >= n2) {
                throw new Exception("Invalid parameters being passed");
            }
            ModelsTypeImpl.ModelImpl modelImpl = (ModelsTypeImpl.ModelImpl)this.factory.createModelsTypeModel();
            this.copyTo(modelImpl, (ModelVO)iPersistable);
            ((Models)this.daoObject).getModelsCollection().add(n, modelImpl);
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new CreateException("Unable to add element = " + iPersistable.getId(), null, exception);
        }
    }

    public void add(IPersistable iPersistable) throws CreateException {
        try {
            if (!(iPersistable instanceof ModelVO)) {
                throw new Exception("Invalid Value Object being passed");
            }
            ModelsTypeImpl.ModelImpl modelImpl = (ModelsTypeImpl.ModelImpl)this.factory.createModelsTypeModel();
            this.copyTo(modelImpl, (ModelVO)iPersistable);
            ((ModelsTypeImpl)this.daoObject).getModelsCollection().add(modelImpl);
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new CreateException("Unable to add element = " + iPersistable.getId(), null, exception);
        }
    }
}

